/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowRuntimeId;
import filenet.vw.base.VWVersion;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSDefinitionBuilder;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSOperationInfoHelper;
import filenet.ws.utils.schema.PESchemaHelper;
import filenet.ws.utils.schema.WSSchemaUtilsEx;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.PortType;

public class WSWorkflowWSDLGenerator {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSWorkflowWSDLGenerator";
    private Definition m_definition = null;
    private WSDefinition m_wsDefinition = null;
    private static String s_unknownSoapAddress = "urn:unknown_determined_at_deploy";
    private static String s_bindingDescription = "Process SOAP binding";
    private static String s_portDescription = "Process port";
    private static String s_faultMessageName = "FaultMessage";
    private VWWorkflowDefinition m_workflowDefinition = null;
    private WSDefinitionBuilder m_definitionBuilder = null;
    private int m_wsdlVersion = 20;
    private WSConstants m_wsConstants = null;
    private VWSession m_vwSession = null;
    private String m_workflowName = null;
    private String m_workClassName = null;
    private String m_workClassRevision = null;
    private String m_serverName = null;
    private int m_regionNumber = 0;
    private String m_productInfoString = null;
    private String m_vwVersion = null;
    private String m_description = null;
    private String m_incomingAttachmentLibId = null;
    private String m_incomingAttachmentFolderId = null;
    private String m_targetNamespace = null;
    private String m_soapAddress = null;
    private ReceiveInstruction[] m_receiveInstructions = null;
    private ReplyInstruction[] m_replyInstructions = null;
    private Hashtable m_partnerLinks = new Hashtable();
    private Hashtable m_portTypes = new Hashtable();
    private Hashtable m_operations = new Hashtable();
    private Hashtable m_messages = new Hashtable();
    private boolean m_faultMessageAdded = false;
    private String m_serviceName = null;
    private String m_WSDL = null;
    private String m_WSDLLink = null;
    private boolean m_bOperationAdded = false;

    public void releaseReferences() {
        block7: {
            try {
                int i;
                this.m_definition = null;
                this.m_workflowDefinition = null;
                this.m_wsConstants = null;
                this.m_vwSession = null;
                this.m_workflowName = null;
                this.m_workClassName = null;
                this.m_workClassRevision = null;
                this.m_serverName = null;
                this.m_productInfoString = null;
                this.m_vwVersion = null;
                this.m_description = null;
                this.m_incomingAttachmentLibId = null;
                this.m_incomingAttachmentFolderId = null;
                this.m_targetNamespace = null;
                this.m_soapAddress = null;
                if (this.m_receiveInstructions != null) {
                    for (i = 0; i < this.m_receiveInstructions.length; ++i) {
                        if (this.m_receiveInstructions[i] == null) continue;
                        this.m_receiveInstructions[i].releaseReferences();
                        this.m_receiveInstructions[i] = null;
                    }
                }
                this.m_receiveInstructions = null;
                if (this.m_replyInstructions != null) {
                    for (i = 0; i < this.m_replyInstructions.length; ++i) {
                        if (this.m_replyInstructions[i] == null) continue;
                        this.m_replyInstructions[i].releaseReferences();
                        this.m_replyInstructions[i] = null;
                    }
                }
                this.m_replyInstructions = null;
                this.m_partnerLinks.clear();
                this.m_partnerLinks = null;
                this.m_portTypes.clear();
                this.m_portTypes = null;
                this.m_operations.clear();
                this.m_operations = null;
                this.m_messages.clear();
                this.m_messages = null;
                this.m_serviceName = null;
                this.m_WSDL = null;
                this.m_WSDLLink = null;
                this.m_wsDefinition = null;
                if (this.m_definitionBuilder != null) {
                    this.m_definitionBuilder.releaseReferences();
                    this.m_definitionBuilder = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block7;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public void releaseWSDefinitionReference() {
        if (this.m_wsDefinition != null) {
            this.m_wsDefinition.releaseReferences();
            this.m_wsDefinition = null;
        }
    }

    public WSWorkflowWSDLGenerator(VWSession vwSession, VWWorkflowDefinition definition, String soapAddress) throws Exception {
        this.m_vwSession = vwSession;
        this.setWorkflowDefinition(definition);
        this.setSoapAddress(soapAddress);
    }

    private void setWorkflowDefinition(VWWorkflowDefinition definition) throws Exception {
        this.m_workflowDefinition = definition;
    }

    private void setSoapAddress(String soapAddress) {
        this.m_soapAddress = soapAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWSDLURL(String cpName, String wcName, int workspaceID, boolean bIgnorVersion) throws VWException {
        String m_method = "getWSDLURL";
        String WSDLLink = VWIDMBaseFactory.instance().getProperties().getProperty("p8bpm.listener.url") + "/wscp" + WSConstants.UTF8Encode(cpName) + "/wc/" + WSConstants.UTF8Encode(wcName);
        if (!bIgnorVersion) {
            WSDLLink = WSDLLink + "/" + Integer.toString(workspaceID);
        }
        WSDLLink = WSDLLink + "?wsdl";
        WSDefinition wsDef = null;
        try {
            block9: {
                try {
                    wsDef = new WSDefinition(WSDLLink);
                    WSPortType[] ports = wsDef.getPortTypes();
                    if (ports == null || ports[0] == null) break block9;
                    String defaultPortTypeName = ports[0].getName();
                    WSPort defaultPort = wsDef.getDefaultPort(defaultPortTypeName);
                    String s = defaultPort.getEndpoint();
                    int index = s.indexOf("P8BPMWSBroker");
                    int index2 = WSDLLink.indexOf("P8BPMWSBroker");
                    String b = s.substring(0, index) + WSDLLink.substring(index2);
                    if (logger.isFinest()) {
                        logger.finest(m_className, "getWSDLURL", b);
                    }
                    WSDLLink = b;
                }
                catch (Throwable t) {
                    Object var15_16 = null;
                    if (wsDef != null) {
                        wsDef.releaseReferences();
                        wsDef = null;
                    }
                }
            }
            Object var15_15 = null;
            if (wsDef != null) {
                wsDef.releaseReferences();
                wsDef = null;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (wsDef != null) {
                wsDef.releaseReferences();
                wsDef = null;
            }
            throw throwable;
        }
        return WSDLLink;
    }

    public Definition generateWSDL() throws Exception, VWException {
        String m_method = "generateWSDL";
        logger.entering(m_className, "generateWSDL");
        try {
            Object runtimeId;
            if (this.m_definition == null) {
                VWAttachment folderAttachment;
                String incomingAttachmentFolder;
                if (this.m_workflowDefinition == null) {
                    VWException ex = new VWException("filenet.ws.utils.workflowDefinitionNotSet", "Generate WSDL from workflow: Workflow definition not set");
                    logger.throwing(m_className, "generateWSDL", ex);
                    throw ex;
                }
                this.m_workflowName = this.m_workflowDefinition.getName();
                if (this.m_soapAddress == null) {
                    this.m_soapAddress = s_unknownSoapAddress;
                }
                runtimeId = this.m_workflowDefinition.getRuntimeId();
                if (this.m_vwSession != null) {
                    if (this.m_workClassName == null && runtimeId != null) {
                        int workClassId = ((VWWorkflowRuntimeId)runtimeId).getWorkClassId();
                        this.m_workClassName = this.m_vwSession.convertIdToClassName(workClassId, false);
                        this.m_workClassRevision = this.m_workflowDefinition.getVersionAgnostic() ? "0" : Integer.toString(((VWWorkflowRuntimeId)runtimeId).getWorkClassRevision());
                        this.m_wsdlVersion = ((VWWorkflowRuntimeId)runtimeId).getWSDLVersion();
                        this.m_wsConstants = WSConstants.getWSConstants(this.m_wsdlVersion);
                    }
                    this.m_serverName = this.m_vwSession.getServerName();
                    this.m_regionNumber = this.m_vwSession.getIsolatedRegion();
                }
                if (this.m_vwVersion == null) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "generateWSDL", "runtimeId = " + runtimeId);
                    }
                    VWVersion vwVersion = new VWVersion((VWWorkflowRuntimeId)runtimeId);
                    if (this.m_workflowDefinition.getVersionAgnostic()) {
                        vwVersion.resetWorkspaceId();
                    }
                    this.m_vwVersion = vwVersion.toString();
                }
                this.m_description = this.m_workflowDefinition.getDescription();
                StringBuffer buf = new StringBuffer();
                if (this.m_workClassName != null) {
                    buf.append("/").append(WSConstants.UTF8Encode(this.m_workClassName));
                }
                this.m_productInfoString = buf.toString();
                this.m_targetNamespace = this.m_wsConstants.P8BPM_NS_WSDL_PREFIX + this.m_productInfoString;
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling WSDefinitionBuilder ctor");
                }
                this.m_definitionBuilder = new WSDefinitionBuilder(this.m_productInfoString, this.m_wsConstants, this.m_targetNamespace, this.m_description);
                if (this.m_wsConstants.getValidateUsingSchema() && this.m_workflowDefinition.getValidateUsingSchema()) {
                    this.m_definitionBuilder.setValidateUsingSchema(true);
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling WorkflowDefinition.getIncomingWSAttachmentFolder");
                }
                if ((incomingAttachmentFolder = this.m_workflowDefinition.getIncomingWSAttachmentFolder()) != null && (folderAttachment = new VWAttachment(incomingAttachmentFolder)) != null) {
                    this.m_incomingAttachmentLibId = folderAttachment.getLibraryName();
                    this.m_incomingAttachmentFolderId = folderAttachment.getId();
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling getReceiveReplyInstructions");
                }
                this.getReceiveReplyInstructions();
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling getPartnerLinks");
                }
                this.getPartnerLinks();
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling addSchemas");
                }
                this.addSchemas();
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling addService");
                }
                this.addService();
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling addReceiveInstructions");
                }
                this.addReceiveInstructions();
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling addReplyInstructions");
                }
                this.addReplyInstructions();
                if (!(this.m_receiveInstructions != null && this.m_receiveInstructions.length != 0 || this.m_replyInstructions != null && this.m_replyInstructions.length != 0)) {
                    VWException ex = new VWException("filenet.ws.utils.wfDefHasNoWebServicesSteps", "Generate WSDL from workflow: workflow definition has no Web Services steps");
                    logger.throwing(m_className, "generateWSDL", ex);
                    throw ex;
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling addOperations");
                }
                this.addOperations();
                if (logger.isFinest()) {
                    logger.finest(m_className, "generateWSDL", "calling WSDefinitionBuilder.getDefinition");
                }
                this.m_definition = this.m_definitionBuilder.getDefinition();
            }
            runtimeId = this.m_definition;
            Object var7_10 = null;
            logger.exiting(m_className, "generateWSDL");
            return runtimeId;
        }
        catch (Throwable t) {
            try {
                logger.throwing(m_className, "generateWSDL", t);
                throw new VWException(t);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                logger.exiting(m_className, "generateWSDL");
                throw throwable;
            }
        }
    }

    public Definition getDefinition() throws Exception {
        if (this.m_definition == null) {
            this.generateWSDL();
        }
        return this.m_definition;
    }

    public static String toXML(Definition definition) throws Exception {
        if (definition != null) {
            return WSDefinition.definitionToString(definition);
        }
        return null;
    }

    public WSDefinition getWSDefinition() throws Throwable {
        String m_method = "getWSDefinition";
        logger.entering(m_className, "getWSDefinition");
        try {
            Object definition;
            if (this.m_wsDefinition == null && (definition = this.getDefinition()) != null) {
                this.m_wsDefinition = WSDefinition.getWSDefinition(definition);
            }
            definition = this.m_wsDefinition;
            Object var4_4 = null;
            logger.exiting(m_className, "getWSDefinition");
            return definition;
        }
        catch (Throwable e) {
            try {
                logger.throwing(m_className, "getWSDefinition", e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                logger.exiting(m_className, "getWSDefinition");
                throw throwable;
            }
        }
    }

    public String getWSDLXML() throws Exception {
        Definition definition = this.getDefinition();
        if (definition != null) {
            return WSDefinition.definitionToString(definition);
        }
        return null;
    }

    private void getReceiveReplyInstructions() throws VWException {
        this.m_receiveInstructions = null;
        this.m_replyInstructions = null;
        VWMapDefinition[] maps = this.m_workflowDefinition.getMaps();
        if (maps != null && maps.length > 0) {
            VWMapDefinition map = null;
            VWMapNode[] mapNodes = null;
            VWCompoundStepDefinition step = null;
            VWInstructionDefinition[] instructions = null;
            Vector<ReceiveInstruction> receiveInstructions = new Vector<ReceiveInstruction>();
            Vector<ReplyInstruction> replyInstructions = new Vector<ReplyInstruction>();
            int mapId = -1;
            for (int i = 0; i < maps.length; ++i) {
                map = maps[i];
                if (map == null) continue;
                mapId = map.getMapId();
                mapNodes = map.getSteps();
                if (mapNodes == null || mapNodes.length <= 0) continue;
                for (int j = 0; j < mapNodes.length; ++j) {
                    if (mapNodes[j] == null || !(mapNodes[j] instanceof VWCompoundStepDefinition) || (instructions = (step = (VWCompoundStepDefinition)mapNodes[j]).getInstructions()) == null || instructions.length <= 0) continue;
                    for (int k = 0; k < instructions.length; ++k) {
                        if (instructions[k] == null) continue;
                        if (instructions[k] instanceof VWReceiveInstruction) {
                            receiveInstructions.add(new ReceiveInstruction(mapId, (VWReceiveInstruction)instructions[k]));
                            continue;
                        }
                        if (!(instructions[k] instanceof VWReplyInstruction)) continue;
                        replyInstructions.add(new ReplyInstruction(mapId, (VWReplyInstruction)instructions[k]));
                    }
                }
            }
            if (receiveInstructions != null && receiveInstructions.size() > 0) {
                this.m_receiveInstructions = new ReceiveInstruction[receiveInstructions.size()];
                receiveInstructions.toArray(this.m_receiveInstructions);
            }
            if (replyInstructions != null && replyInstructions.size() > 0) {
                this.m_replyInstructions = new ReplyInstruction[replyInstructions.size()];
                replyInstructions.toArray(this.m_replyInstructions);
            }
        }
    }

    private void getPartnerLinks() throws VWException {
        VWPartnerLinkDefinition[] partnerLinks = this.m_workflowDefinition.getPartnerLinks();
        if (partnerLinks != null && partnerLinks.length > 0) {
            for (int i = 0; i < partnerLinks.length; ++i) {
                if (partnerLinks[i] == null || partnerLinks[i].getMyPortType() == null) continue;
                this.m_partnerLinks.put(partnerLinks[i].getName(), partnerLinks[i]);
            }
        }
    }

    private void addFaultMessage() throws Exception {
        if (!this.m_faultMessageAdded) {
            this.m_definitionBuilder.addMessage("FaultMessage", null, "string");
            this.m_faultMessageAdded = true;
        }
    }

    private void addSchemas() throws Exception, VWException {
        if (this.m_definitionBuilder == null) {
            return;
        }
        VWSchema[] schemas = this.m_workflowDefinition.getSchemas();
        if (schemas != null && schemas.length > 0) {
            for (int i = 0; i < schemas.length; ++i) {
                if (schemas[i] == null || schemas[i].getName() == null) continue;
                String fileName = schemas[i].getFileName();
                WSSchemaUtilsEx schema = null;
                schema = fileName != null && fileName.trim().length() != 0 ? PESchemaHelper.GetSchemaFromServer(this.m_vwSession, fileName.trim(), this.m_soapAddress) : PESchemaHelper.GetSchemaFromText(this.m_vwSession, schemas[i].getSchema(), this.m_soapAddress);
                this.m_definitionBuilder.addSchema(schemas[i].getName(), schema.getMainSchema());
            }
        }
    }

    private void addService() throws Exception, VWException {
        if (this.m_definitionBuilder == null) {
            return;
        }
        this.m_serviceName = this.getServiceName(this.m_workflowName);
        this.m_definitionBuilder.addService(this.m_serviceName, this.m_description);
    }

    private void addReceiveInstructions() throws Exception {
        VWReceiveInstruction instruction = null;
        if (this.m_receiveInstructions != null && this.m_receiveInstructions.length > 0) {
            for (int i = 0; i < this.m_receiveInstructions.length; ++i) {
                String operationName;
                if (this.m_receiveInstructions[i] == null || (operationName = (instruction = this.m_receiveInstructions[i].getInstruction()).getOperationName()) == null) continue;
                Object obj = this.m_operations.get(operationName);
                if (obj != null && obj instanceof OperationInfo) {
                    ((OperationInfo)obj).addReceive(instruction);
                    continue;
                }
                OperationInfo operationInfo = new OperationInfo(this.m_serviceName, this.m_receiveInstructions[i].getMapId(), instruction);
                this.m_operations.put(operationName, operationInfo);
            }
        }
    }

    private void addReplyInstructions() throws Exception {
        VWReplyInstruction instruction = null;
        if (this.m_replyInstructions != null && this.m_replyInstructions.length > 0) {
            for (int i = 0; i < this.m_replyInstructions.length; ++i) {
                String operationName;
                if (this.m_replyInstructions[i] == null || (operationName = (instruction = this.m_replyInstructions[i].getInstruction()).getOperationName()) == null) continue;
                Object obj = this.m_operations.get(operationName);
                if (obj != null && obj instanceof OperationInfo) {
                    ((OperationInfo)obj).addReply(instruction);
                    continue;
                }
                OperationInfo operationInfo = new OperationInfo(this.m_serviceName, instruction);
                this.m_operations.put(operationName, operationInfo);
            }
        }
    }

    private void addOperations() throws Exception {
        if (this.m_operations != null && this.m_operations.size() > 0) {
            Collection operations = this.m_operations.values();
            if (operations == null || operations.isEmpty()) {
                return;
            }
            Iterator it = operations.iterator();
            if (it == null) {
                return;
            }
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof OperationInfo)) continue;
                ((OperationInfo)obj).addOperation();
            }
        }
    }

    private void addPortType(String portTypeName) throws Exception {
        String method = "addPortType";
        if (portTypeName == null) {
            VWException ex = new VWException("filenet.ws.utils.nullPortType", "Port type name is null");
            logger.throwing(m_className, method, ex);
            throw ex;
        }
        if (this.m_portTypes.get(portTypeName) == null && this.m_definitionBuilder.getPortType(portTypeName) == null) {
            PortType portType = this.m_definitionBuilder.addPortType(portTypeName, "PortType description");
            this.m_portTypes.put(portTypeName, portType);
        }
    }

    String getServiceName(String workflowName) {
        return workflowName + "Service";
    }

    String getServiceName() {
        return this.m_serviceName;
    }

    class ReplyInstruction {
        private int m_mapId = -1;
        private VWReplyInstruction m_replyInstruction = null;

        void releaseReferences() {
            this.m_replyInstruction = null;
        }

        ReplyInstruction(int mapId, VWReplyInstruction replyInstruction) {
            this.m_replyInstruction = replyInstruction;
            this.m_mapId = mapId;
        }

        int getMapId() {
            return this.m_mapId;
        }

        VWReplyInstruction getInstruction() {
            return this.m_replyInstruction;
        }
    }

    class ReceiveInstruction {
        private int m_mapId = -1;
        private VWReceiveInstruction m_receiveInstruction = null;

        void releaseReferences() {
            this.m_receiveInstruction = null;
        }

        ReceiveInstruction(int mapId, VWReceiveInstruction receiveInstruction) {
            this.m_receiveInstruction = receiveInstruction;
            this.m_mapId = mapId;
        }

        int getMapId() {
            return this.m_mapId;
        }

        VWReceiveInstruction getInstruction() {
            return this.m_receiveInstruction;
        }
    }

    class OperationInfo {
        String m_mapId = null;
        String m_onlineId = null;
        VWReceiveInstruction m_receiveInstruction = null;
        VWReplyInstruction m_replyInstruction = null;
        private String m_myPortType = null;
        private String m_portTypeName = null;
        private String m_serviceName = null;
        private String m_operationName = null;
        private MessageInfo m_inputMessage = null;
        private MessageInfo m_outputMessage = null;
        private boolean m_bOutputAttachments = false;
        private boolean m_bInputAttachments = false;
        private boolean m_bInputAuthentication = false;
        private boolean m_bReplyHeader = false;
        private Vector m_faultNames = new Vector();
        private String m_opInfoElement = null;

        OperationInfo(String serviceName, int mapId, VWReceiveInstruction instruction) throws Exception {
            this.m_mapId = Integer.toString(mapId);
            this.m_serviceName = serviceName;
            this.addReceive(instruction);
        }

        OperationInfo(String serviceName, VWReplyInstruction instruction) throws Exception {
            this.m_serviceName = serviceName;
            this.addReply(instruction);
        }

        void addReceive(VWReceiveInstruction instruction) throws Exception {
            String portTypeName = null;
            String operationName = null;
            String method = "addReceive";
            this.m_opInfoElement = WSOperationInfoHelper.createPOOperationInfo(instruction, WSWorkflowWSDLGenerator.this.m_workflowDefinition.getVersionAgnostic(), WSWorkflowWSDLGenerator.this.m_wsdlVersion);
            this.m_onlineId = Integer.toString(instruction.getOnlineId());
            String partnerLinkName = instruction.getPartnerLinkName();
            Object obj = WSWorkflowWSDLGenerator.this.m_partnerLinks.get(partnerLinkName);
            if (obj != null && obj instanceof VWPartnerLinkDefinition) {
                VWPartnerLinkDefinition partnerLink = (VWPartnerLinkDefinition)obj;
                this.m_myPortType = partnerLink.getMyPortType();
                portTypeName = this.getPortTypeName();
            }
            operationName = instruction.getOperationName();
            if (this.m_portTypeName == null && this.m_operationName == null) {
                this.m_portTypeName = portTypeName;
                this.m_operationName = operationName;
            } else if (!this.isSameOperation(this.m_serviceName, portTypeName, operationName)) {
                Object[] arguments = new String[]{this.m_serviceName, portTypeName, operationName, this.m_serviceName, this.m_portTypeName, this.m_operationName};
                VWException ex = new VWException("filenet.ws.utils.addingReceiveInstToWrongOp", "Adding receive instruction({0}, {1}, {2}) to wrong operation({3}. {4}, {5}).", arguments);
                logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                throw ex;
            }
            boolean bAttachments = false;
            boolean bAuthentication = instruction.getAuthentication();
            String elementName = instruction.getMessageFromElementName();
            String schemaName = instruction.getMessageFromSchemaName();
            String messageName = this.composeInputMessageName();
            VWWebServiceParameterDefinition[] inputParameters = instruction.getParameterDefinitions();
            MessageInfo message = null;
            if (inputParameters != null) {
                message = new MessageInfo(messageName, inputParameters);
                if (message != null) {
                    bAttachments |= message.getHasAttachment();
                }
            } else {
                message = new MessageInfo(messageName, schemaName, elementName);
            }
            if (this.m_receiveInstruction != null) {
                if (!this.isSameReceive(bAttachments, bAuthentication, message)) {
                    Object[] arguments = new String[]{this.m_serviceName, portTypeName, operationName, this.m_serviceName, this.m_portTypeName, this.m_operationName};
                    VWException ex = new VWException("filenet.ws.utils.addingReceiveInstToWrongOp", "Adding receive instruction({0}, {1}, {2}) to wrong operation({3}. {4}, {5}.", arguments);
                    logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                    throw ex;
                }
            } else {
                this.m_receiveInstruction = instruction;
                this.m_bInputAttachments = bAttachments;
                this.m_bInputAuthentication = bAuthentication;
                this.m_inputMessage = message;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void addReply(VWReplyInstruction instruction) throws Exception {
            String portTypeName = null;
            String operationName = null;
            String method = "addReply";
            String partnerLinkName = instruction.getPartnerLinkName();
            Object obj = WSWorkflowWSDLGenerator.this.m_partnerLinks.get(partnerLinkName);
            if (obj != null && obj instanceof VWPartnerLinkDefinition) {
                VWPartnerLinkDefinition partnerLink = (VWPartnerLinkDefinition)obj;
                this.m_myPortType = partnerLink.getMyPortType();
                portTypeName = this.getPortTypeName();
            }
            operationName = instruction.getOperationName();
            if (this.m_portTypeName == null && this.m_operationName == null) {
                this.m_portTypeName = portTypeName;
                this.m_operationName = operationName;
            } else if (!this.isSameOperation(this.m_serviceName, portTypeName, operationName)) {
                Object[] arguments = new String[]{this.m_serviceName, portTypeName, operationName, this.m_serviceName, this.m_portTypeName, this.m_operationName};
                VWException ex = new VWException("filenet.ws.utils.addingReplyInstToWrongOp", "Adding reply instruction({0}, {1}, {2}) to wrong operation({3}. {4}, {5}.", arguments);
                logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                throw ex;
            }
            boolean bOutputAttachments = false;
            VWWebServiceParameterDefinition[] outputParameters = instruction.getParameterDefinitions();
            String elementName = instruction.getMessageFromElementName();
            String schemaName = instruction.getMessageFromSchemaName();
            String messageName = this.composeOutputMessageName();
            MessageInfo message = null;
            if (outputParameters != null) {
                message = new MessageInfo(messageName, outputParameters);
                if (message != null) {
                    bOutputAttachments |= message.getHasAttachment();
                }
            } else if (elementName != null && schemaName != null) {
                message = new MessageInfo(messageName, schemaName, elementName);
            }
            String faultName = null;
            if (this.m_replyInstruction != null && this.m_outputMessage != null) {
                if (message != null && !this.isSameReply(bOutputAttachments, message)) {
                    Object[] arguments = new String[]{this.m_serviceName, portTypeName, operationName, this.m_serviceName, this.m_portTypeName, this.m_operationName};
                    VWException ex = new VWException("filenet.ws.utils.addingReplyInstToWrongOp", "Adding reply instruction({0}, {1}, {2}) to wrong operation({3}. {4}, {5}.", arguments);
                    logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                    throw ex;
                }
                faultName = instruction.getFaultName();
            } else {
                this.m_replyInstruction = instruction;
                this.m_bOutputAttachments = bOutputAttachments;
                this.m_outputMessage = message;
                faultName = instruction.getFaultName();
            }
            if (faultName != null) {
                this.addFault(faultName);
            }
        }

        boolean isSameOperation(String serviceName, String portTypeName, String operationName) {
            if (VWStringUtils.compare(this.m_serviceName, serviceName) != 0) {
                return false;
            }
            if (VWStringUtils.compare(this.m_portTypeName, portTypeName) != 0) {
                return false;
            }
            return VWStringUtils.compare(this.m_operationName, operationName) == 0;
        }

        boolean isSameReceive(boolean bHasInputAttachments, boolean bAuthentication, MessageInfo message) {
            if (this.getHasInputAttachments() != bHasInputAttachments) {
                return false;
            }
            if (this.getInputAuthentication() != bAuthentication) {
                return false;
            }
            return !(this.m_inputMessage != null ? !this.m_inputMessage.isSameMessage(message) : message != null);
        }

        boolean isSameReply(boolean bHasAttachements, MessageInfo message) {
            if (this.getHasOutputAttachments() != bHasAttachements) {
                return false;
            }
            return !(this.m_outputMessage != null ? !this.m_outputMessage.isSameMessage(message) : message != null);
        }

        private void addFault(String faultName) {
            if (faultName == null || faultName.length() == 0) {
                return;
            }
            if (this.m_faultNames == null) {
                this.m_faultNames = new Vector();
            }
            Object obj = null;
            for (int i = 0; i < this.m_faultNames.size(); ++i) {
                obj = this.m_faultNames.get(i);
                if (obj == null || faultName.compareTo((String)obj) != 0) continue;
                return;
            }
            this.m_faultNames.add(faultName);
        }

        String getOperationName() {
            return this.m_operationName;
        }

        MessageInfo getInputMessage() {
            return this.m_inputMessage;
        }

        MessageInfo getOutputMessage() {
            return this.m_outputMessage;
        }

        boolean getInputAuthentication() {
            return this.m_bInputAuthentication;
        }

        boolean getHasInputAttachments() {
            return this.m_bInputAttachments;
        }

        boolean getHasOutputAttachments() {
            return this.m_bOutputAttachments;
        }

        void setInputMessage(MessageInfo inputMessage) throws Exception {
            if (inputMessage == null) {
                return;
            }
            if (this.m_inputMessage == null) {
                this.m_inputMessage = inputMessage;
            } else if (!this.m_inputMessage.isSameMessage(inputMessage)) {
                VWException ex = new VWException("filenet.ws.utils.diffInputMsgHasAlreadySet", "A different input message has already been set : {0}", this.m_inputMessage.getName());
                logger.throwing(WSWorkflowWSDLGenerator.m_className, "setInputMessage", ex);
                throw ex;
            }
        }

        void setOuputMessage(MessageInfo outputMessage) throws Exception {
            if (outputMessage == null) {
                return;
            }
            if (this.m_outputMessage == null) {
                this.m_outputMessage = outputMessage;
            } else if (!this.m_outputMessage.isSameMessage(outputMessage)) {
                VWException ex = new VWException("filenet.ws.utils.diffOutputMsgHasAlreadySet", "A different output message has already been set : {0}", this.m_outputMessage.getName());
                logger.throwing(WSWorkflowWSDLGenerator.m_className, "setOutputMessage", ex);
                throw ex;
            }
        }

        void addOperation() throws Exception {
            if (this.m_serviceName == null || this.m_portTypeName == null || this.m_operationName == null) {
                return;
            }
            if (this.m_inputMessage == null) {
                this.m_inputMessage = new MessageInfo(this.composeInputMessageName(), null);
            }
            if (this.m_inputMessage != null) {
                this.m_inputMessage.addMessage();
            }
            if (this.m_outputMessage != null) {
                this.m_outputMessage.addMessage();
                this.m_bReplyHeader = true;
            }
            WSWorkflowWSDLGenerator.this.addPortType(this.m_portTypeName);
            WSWorkflowWSDLGenerator.this.m_definitionBuilder.addOperation(this.getPortTypeName(), this.getOperationName(), this.getInputMessageName(), this.getOutputMessageName(), this.m_opInfoElement);
            if (this.m_faultNames != null && this.m_faultNames.size() > 0) {
                Object obj = null;
                Object faultName = null;
                WSWorkflowWSDLGenerator.this.addFaultMessage();
                for (int i = 0; i < this.m_faultNames.size(); ++i) {
                    obj = this.m_faultNames.get(i);
                    if (obj == null || !(obj instanceof String)) continue;
                    WSWorkflowWSDLGenerator.this.m_definitionBuilder.addOperationFault(this.getPortTypeName(), this.getOperationName(), obj, s_faultMessageName);
                }
            }
            if (WSWorkflowWSDLGenerator.this.m_definitionBuilder.getBinding(this.getBindingName()) == null) {
                WSWorkflowWSDLGenerator.this.m_definitionBuilder.addSoapBinding(this.getBindingName(), this.getPortTypeName(), s_bindingDescription);
            }
            if (WSWorkflowWSDLGenerator.this.m_definitionBuilder.getPort(WSWorkflowWSDLGenerator.this.getServiceName(), this.getPortName()) == null) {
                WSWorkflowWSDLGenerator.this.m_definitionBuilder.addPort(WSWorkflowWSDLGenerator.this.getServiceName(), this.getPortName(), this.getBindingName(), WSWorkflowWSDLGenerator.this.m_soapAddress, s_portDescription);
            }
            if (this.m_bInputAuthentication) {
                // empty if block
            }
            if (this.m_bInputAttachments) {
                WSWorkflowWSDLGenerator.this.m_definitionBuilder.addInputMimeAttachments(this.getBindingName(), this.getOperationName());
            }
            if (this.m_bOutputAttachments) {
                WSWorkflowWSDLGenerator.this.m_definitionBuilder.addOutputMimeAttachments(this.getBindingName(), this.getOperationName());
            }
            WSWorkflowWSDLGenerator.this.m_definitionBuilder.addSoapAction(this.getBindingName(), this.getOperationName(), this.getSoapActionURI());
        }

        private String getPortTypeName() {
            return this.m_myPortType;
        }

        private String getPortName() {
            return this.m_myPortType + "Port";
        }

        private String getBindingName() {
            return this.m_myPortType + "SoapBinding";
        }

        private String getInputMessageName() {
            if (this.m_inputMessage != null) {
                return this.m_inputMessage.getName();
            }
            return null;
        }

        private String getOutputMessageName() {
            if (this.m_outputMessage != null) {
                return this.m_outputMessage.getName();
            }
            return null;
        }

        private String getPortTypeName(String portType) {
            return portType;
        }

        private String getPortName(String portType) {
            return portType + "Port";
        }

        private String getBindingName(String portType) {
            return portType + "SoapBinding";
        }

        private String getSoapActionURI() throws Exception {
            String m_method = "getSoapActionURI";
            if (logger.isFinest()) {
                logger.finest(WSWorkflowWSDLGenerator.m_className, "getSoapActionURI", "vwVersion = " + WSWorkflowWSDLGenerator.this.m_vwVersion);
            }
            P8BPMSoapActionURI soapAction = new P8BPMSoapActionURI();
            soapAction.setVWVersion(WSWorkflowWSDLGenerator.this.m_vwVersion);
            soapAction.setWorkClassName(WSWorkflowWSDLGenerator.this.m_workClassName);
            soapAction.setPortType(this.getPortTypeName());
            soapAction.setOperation(this.getOperationName());
            soapAction.setMapId(this.m_mapId);
            soapAction.setOnlineId(this.m_onlineId);
            soapAction.setWorkClassRevision(WSWorkflowWSDLGenerator.this.m_workClassRevision);
            soapAction.setWSDLVersion(WSWorkflowWSDLGenerator.this.m_wsdlVersion);
            if (WSWorkflowWSDLGenerator.this.m_incomingAttachmentLibId != null && WSWorkflowWSDLGenerator.this.m_incomingAttachmentFolderId != null) {
                soapAction.setWsLibraryId(WSWorkflowWSDLGenerator.this.m_incomingAttachmentLibId);
                soapAction.setWsFolderId(WSWorkflowWSDLGenerator.this.m_incomingAttachmentFolderId);
            }
            String soapActionString = soapAction.toStringEx();
            return XMLHelper.toXMLString(soapActionString);
        }

        private String composeOutputMessageName() {
            if (this.m_operationName != null) {
                return this.m_operationName + "Output";
            }
            return null;
        }

        private String composeInputMessageName() {
            if (this.m_operationName != null) {
                return this.m_operationName + "Input";
            }
            return null;
        }
    }

    class MessageInfo {
        private String m_messageName = null;
        private String m_schemaName = null;
        private String m_elementName = null;
        private boolean m_bAdded = false;
        private Vector m_parameters = null;
        private boolean m_bHasAttachments = false;

        MessageInfo(String messageName, VWWebServiceParameterDefinition[] parameters) {
            this.m_messageName = messageName;
            if (parameters != null) {
                this.m_parameters = this.getParameters(parameters);
            }
        }

        MessageInfo(String messageName, String schemaName, String elementName) {
            this.m_messageName = messageName;
            this.m_schemaName = schemaName;
            this.m_elementName = elementName;
        }

        String getName() {
            return this.m_messageName;
        }

        String getSchemaName() {
            return this.m_schemaName;
        }

        String getElementName() {
            return this.m_elementName;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj instanceof MessageInfo && this.isSameMessage((MessageInfo)obj);
        }

        boolean isSameMessage(MessageInfo msgInfo) {
            if (!this.isSameString(this.m_messageName, msgInfo.getName())) {
                return false;
            }
            if (!this.isSameString(this.m_schemaName, msgInfo.getSchemaName())) {
                return false;
            }
            if (!this.isSameString(this.m_elementName, msgInfo.getElementName())) {
                return false;
            }
            return this.isSameParameters(this.m_parameters, msgInfo.m_parameters);
        }

        boolean isSameMessage(String msgName, String schemaName, String elementName) {
            if (!this.isSameString(this.m_messageName, msgName)) {
                return false;
            }
            if (!this.isSameString(this.m_schemaName, schemaName)) {
                return false;
            }
            return this.isSameString(this.m_elementName, elementName);
        }

        boolean isSameString(String str1, String str2) {
            if (str1 == null && str2 == null) {
                return true;
            }
            return str1 != null && str2 != null && str1.compareTo(str2) == 0;
        }

        private boolean isSameParameters(Vector parameters1, Vector parameters2) {
            if (parameters1 != null) {
                if (parameters2 == null) {
                    return false;
                }
                if (parameters1.size() != parameters2.size()) {
                    return false;
                }
                Object value1 = null;
                Object value2 = null;
                Object[] param1 = null;
                Object[] param2 = null;
                int n = parameters1.size();
                for (int i = 0; i < n; ++i) {
                    value1 = parameters1.get(i);
                    value2 = parameters2.get(i);
                    if (value1 != null) {
                        if (value2 == null) {
                            return false;
                        }
                        if (value1 instanceof Object[] && value2 instanceof Object[]) {
                            param1 = value1;
                            param2 = value2;
                            if (param1.length != 2 || param2.length != 2) {
                                return false;
                            }
                            if (param1[0] == null || param2[0] == null || param1[1] == null || param2[1] == null) {
                                return false;
                            }
                            if (param1[0] instanceof String && param2[0] instanceof String) {
                                if (((String)param1[0]).compareTo((String)param2[0]) != 0) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            if (param1[1] instanceof String) {
                                if (param2[1] instanceof String) {
                                    if (((String)param1[1]).compareTo((String)param2[1]) != 0) {
                                        return false;
                                    }
                                } else {
                                    return false;
                                }
                            }
                            if (!(param1[1] instanceof Vector)) continue;
                            if (param2[1] instanceof Vector) {
                                if (this.isSameParameters((Vector)param1[1], (Vector)param2[1])) continue;
                                return false;
                            }
                            return false;
                        }
                        return false;
                    }
                    if (value2 == null) continue;
                    return false;
                }
            } else if (parameters2 != null) {
                return false;
            }
            return true;
        }

        void addMessage() throws Exception {
            if (this.m_bAdded) {
                return;
            }
            if (this.m_parameters != null) {
                this.addParameterMessage();
            } else if (this.m_schemaName != null && this.m_elementName != null) {
                this.addSchemaMessage();
            } else {
                this.addEmptyMessage();
            }
        }

        boolean isEmptyMessage() {
            if (this.m_parameters != null) {
                return false;
            }
            return this.m_schemaName == null || this.m_elementName == null;
        }

        private void addEmptyMessage() throws Exception {
            if (this.m_messageName == null) {
                return;
            }
            String method = "addEmptyMessage()";
            String s = "addEmptyMessage(" + this.m_messageName + "): ";
            Object obj = WSWorkflowWSDLGenerator.this.m_messages.get(this.m_messageName);
            if (obj != null && obj instanceof MessageInfo) {
                if (((MessageInfo)obj).isEmptyMessage()) {
                    return;
                }
                VWException ex = new VWException("filenet.ws.utils.differentMsgWithSameMsgNameAlreadyAdded", "different message with the same message name already added");
                logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                throw ex;
            }
            WSWorkflowWSDLGenerator.this.m_definitionBuilder.addEmptyMessage(this.m_messageName);
            WSWorkflowWSDLGenerator.this.m_messages.put(this.m_messageName, this);
            this.m_bAdded = true;
        }

        private void addParameterMessage() throws Exception {
            if (this.m_messageName == null || this.m_parameters == null) {
                return;
            }
            String method = "addParameterMessage()";
            String s = "addParameterMessage(" + this.m_messageName + "): ";
            Object obj = WSWorkflowWSDLGenerator.this.m_messages.get(this.m_messageName);
            if (obj != null && obj instanceof MessageInfo) {
                Vector parameters = ((MessageInfo)obj).getParameters();
                if (this.isSameParameters(this.m_parameters, parameters)) {
                    return;
                }
                VWException ex = new VWException("filenet.ws.utils.differentMsgWithSameMsgNameAlreadyAdded", "different message with the same message name already added");
                logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                throw ex;
            }
            WSWorkflowWSDLGenerator.this.m_definitionBuilder.addMessage(this.m_messageName, this.m_parameters);
            WSWorkflowWSDLGenerator.this.m_messages.put(this.m_messageName, this);
            this.m_bAdded = true;
        }

        private void addSchemaMessage() throws Exception {
            String method = "addSchemaMessage(" + this.m_messageName + ", " + this.m_elementName + "):";
            if (this.m_messageName == null || this.m_elementName == null) {
                return;
            }
            MessageInfo msgInfo = new MessageInfo(this.m_messageName, this.m_schemaName, this.m_elementName);
            Object obj = WSWorkflowWSDLGenerator.this.m_messages.get(this.m_messageName);
            if (obj != null && obj instanceof MessageInfo) {
                if (msgInfo.isSameMessage((MessageInfo)obj)) {
                    return;
                }
                VWException ex = new VWException("filenet.ws.utils.differentMsgWithSameMsgNameAlreadyAdded", "different message with the same message name already added");
                logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                throw ex;
            }
            WSWorkflowWSDLGenerator.this.m_definitionBuilder.addMessage(this.m_messageName, this.m_schemaName, this.m_elementName);
            WSWorkflowWSDLGenerator.this.m_messages.put(this.m_messageName, this);
            this.m_bAdded = true;
        }

        private Vector getParameters() {
            return this.m_parameters;
        }

        private int getParameters(Vector wsParameters, VWWebServiceParameterDefinition[] vwParameters, int level, int startIndex) {
            String method = "getParameters";
            if (wsParameters == null || startIndex >= 0 && vwParameters.length > startIndex && level >= 0) {
                int i;
                VWWebServiceParameterDefinition vwParam = null;
                int lexicalLevel = -1;
                int type = -1;
                String name = null;
                String typeName = null;
                boolean bAttachment = false;
                for (i = startIndex; i < vwParameters.length; ++i) {
                    vwParam = vwParameters[i];
                    if (vwParam == null) continue;
                    try {
                        lexicalLevel = vwParam.getLexicalLevel();
                    }
                    catch (VWException ex) {
                        continue;
                    }
                    type = vwParam.getDataType();
                    if (lexicalLevel == 0) {
                        type = -1;
                    }
                    if ((name = vwParam.getName()) == null) continue;
                    Object[] p = new Object[2];
                    p[0] = name;
                    if (lexicalLevel == level) {
                        if (type == -1) {
                            Vector wsParams = new Vector();
                            i = this.getParameters(wsParams, vwParameters, level + 1, i + 1) - 1;
                            if (wsParams.size() <= 0) continue;
                            p[1] = wsParams;
                            wsParameters.add(p);
                            continue;
                        }
                        typeName = null;
                        switch (type) {
                            case 4: {
                                typeName = "Boolean";
                                break;
                            }
                            case 8: {
                                typeName = "Double";
                                break;
                            }
                            case 1: {
                                typeName = "Integer";
                                break;
                            }
                            case 2: {
                                typeName = "String";
                                break;
                            }
                            case 128: {
                                typeName = "xmlString";
                                break;
                            }
                            case 16: {
                                typeName = "Date";
                                break;
                            }
                            case 32: {
                                try {
                                    if (vwParam.isAttachmentByValue()) {
                                        bAttachment = true;
                                        typeName = "attachment";
                                        break;
                                    }
                                    typeName = "attachmentRef";
                                    break;
                                }
                                catch (VWException ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (typeName == null) continue;
                        if (vwParam.getIsArray()) {
                            typeName = typeName + "[]";
                        }
                        this.m_bHasAttachments |= bAttachment;
                        p[1] = typeName;
                        wsParameters.add(p);
                        continue;
                    }
                    if (lexicalLevel > level) {
                        VWException ex = new VWException("filenet.ws.utils.incorrectParameterLexicalLevel", "Adding parameters to WSDL message. Incorrect lexical level.");
                        logger.throwing(WSWorkflowWSDLGenerator.m_className, method, ex);
                        continue;
                    }
                    if (lexicalLevel < level) break;
                }
                return i;
            }
            return startIndex;
        }

        private boolean isFlatVWParameters(VWWebServiceParameterDefinition[] parameters) {
            if (parameters == null || parameters.length == 0) {
                return true;
            }
            int level = -1;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) continue;
                try {
                    if (level == -1) {
                        level = parameters[i].getLexicalLevel();
                        continue;
                    }
                    if (level == parameters[i].getLexicalLevel()) continue;
                    return false;
                }
                catch (VWException ex) {
                    // empty catch block
                }
            }
            return true;
        }

        private Vector getParameters(VWWebServiceParameterDefinition[] parameters) {
            if (parameters == null || parameters.length == 0) {
                return null;
            }
            Vector<Object[]> params = new Vector<Object[]>();
            if (!this.isFlatVWParameters(parameters)) {
                this.getParameters(params, parameters, 0, 0);
                return params;
            }
            Vector<String[]> simpleParams = new Vector<String[]>();
            Vector<String[]> attachmentParams = new Vector<String[]>();
            String name = null;
            String typeName = null;
            String[] parameter = null;
            int type = -1;
            boolean bAttachment = false;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) continue;
                bAttachment = false;
                typeName = null;
                name = parameters[i].getName();
                type = parameters[i].getDataType();
                if (name == null) continue;
                switch (type) {
                    case 4: {
                        typeName = "Boolean";
                        break;
                    }
                    case 8: {
                        typeName = "Double";
                        break;
                    }
                    case 1: {
                        typeName = "Integer";
                        break;
                    }
                    case 2: {
                        typeName = "String";
                        break;
                    }
                    case 128: {
                        typeName = "xmlString";
                        break;
                    }
                    case 16: {
                        typeName = "Date";
                        break;
                    }
                    case 32: {
                        try {
                            if (parameters[i].isAttachmentByValue()) {
                                bAttachment = true;
                                typeName = "attachment";
                                break;
                            }
                            typeName = "attachmentRef";
                            break;
                        }
                        catch (VWException ex) {
                            // empty catch block
                        }
                    }
                }
                if (typeName == null) continue;
                if (parameters[i].getIsArray()) {
                    typeName = typeName + "[]";
                }
                parameter = new String[]{name, typeName};
                this.m_bHasAttachments = bAttachment;
                if (bAttachment) {
                    attachmentParams.add(parameter);
                    continue;
                }
                simpleParams.add(parameter);
            }
            Object[] p = null;
            if (simpleParams != null && simpleParams.size() > 0) {
                p = new Object[]{this.m_messageName + "0", simpleParams};
                params.add(p);
            }
            if (attachmentParams != null && attachmentParams.size() > 0) {
                for (int i = 0; i < attachmentParams.size(); ++i) {
                    p = new Object[]{this.m_messageName + (i + 1), new Vector()};
                    ((Vector)p[1]).add(attachmentParams.get(i));
                    params.add(p);
                }
            }
            return params;
        }

        boolean getHasAttachment() {
            return this.m_bHasAttachments;
        }
    }
}

